/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_utils.h"
#include "udm_alias.h"
#include "udm_match.h"
#include "udm_log.h"


__INDLIB__ int UdmAliasListAdd(UDM_ALIASLIST * AliasList,UDM_ALIAS * Alias,char * err, size_t errsize){
	int res;
	if(AliasList->naliases>=AliasList->maliases){
		AliasList->maliases+=16;
		AliasList->Alias=(UDM_ALIAS *)realloc(AliasList->Alias,AliasList->maliases*sizeof(UDM_ALIAS));
	}
	bzero(&AliasList->Alias[AliasList->naliases],sizeof(AliasList->Alias[AliasList->naliases]));
	
	res=UdmMatchComp(&AliasList->Alias[AliasList->naliases].match,Alias->match.pattern,Alias->match.match_type,Alias->match.case_sense,err,errsize);
	if(res)return(res);
	
	AliasList->Alias[AliasList->naliases].replace=strdup(Alias->replace);
	AliasList->naliases++;
	return(0);
}

void UdmAliasFree(UDM_ALIAS * Alias){
	UdmMatchFree(&Alias->match);
	UDM_FREE(Alias->replace);
}

void UdmAliasListFree(UDM_ALIASLIST * List){
	size_t i;
	for(i=0;i<List->naliases;i++){
		UdmAliasFree(&List->Alias[i]);
	}
	List->naliases=0;
	List->maliases=0;
	UDM_FREE(List->Alias);
}

UDM_ALIAS * UdmAliasFind(UDM_ALIASLIST * List,const char * alias,size_t nparts,UDM_MATCH_PART * Parts){
	size_t i;
	for(i=0;i<List->naliases;i++){
		if(!UdmMatchExec(&List->Alias[i].match,alias,nparts,Parts))
			return(&List->Alias[i]);
	}
	return(NULL);
}

/*
#define DEBUG_ALIAS
*/

int UdmAliasApply(char * res, size_t size,const char * string,UDM_ALIAS * Alias, size_t nparts, UDM_MATCH_PART * Parts)
{
	char * dst;
	int len=0;
	const char * repl;
	
	if(!size)return 0;
	
	repl=Alias->replace;
/*
	printf("Apply '%s' '%s'\n",string,Alias->replace);
*/	
	switch(Alias->match.match_type){
		case UDM_MATCH_REGEX:
			dst=res;

			while((*repl)&&((dst-res)<(size-1))){
				if(*repl=='$'){
					char digit[2];
					int sub;
					size_t len1;
							
					digit[0]=repl[1];
					digit[1]='\0';
					sub=atoi(digit);
#ifdef DEBUG_ALIAS
					fprintf(stderr,"Match %d-%d\n",Parts[sub].beg,Parts[sub].end);
#endif
					if((Parts[sub].beg>-1)&&(Parts[sub].end>Parts[sub].beg)){
						len1=Parts[sub].end-Parts[sub].beg;
						strncpy(dst,string+Parts[sub].beg,len1);
						dst+=len1;
						*dst='\0';
					}
					repl+=2;
				}else{
					*dst=*repl;
					dst++;
					*dst='\0';
					repl++;
				}
			}
			*dst='\0';
			len=dst-res;
#ifdef DEBUG_ALIAS							
			fprintf(stderr,"'%s' '%s' '%s' '%s'\n",string,Alias->match.pattern,repl,res);
#endif		
			break;
			
		case UDM_MATCH_BEGIN:
			/*
			printf("HERE '%s' '%s' '%s' %d\n",Alias->replace,string,Alias->match.pattern,size);
			*/
			len=snprintf(res,size-1,"%s%s",Alias->replace,string+strlen(Alias->match.pattern));
			break;
		default:
			*res='\0';
			len=0;
			break;
	}
	return len;
}


int UdmAliasProg(UDM_AGENT *Indexer,const char *alias_prog,const char *argument,char *res, size_t rsize){
	FILE		*aprog;
	char		cmd[UDM_URLSIZE*3]="";
	char		arg[UDM_URLSIZE*3]="";
	char		*ares=NULL;
	char		*args[1];
	const char	*a;
	char		*c;
 	
	/* Escape command argument */
	for(a=argument,c=arg;*a;a++,c++){
		switch(*a){
			case '\\':
			case '\'':
			case '\"':
				(*c)='\\';
				c++;
				break;
			default:
				break;
		}
		*c=*a;
	}
	*c='\0';
	args[0]=arg;
	
	UdmBuildParamStr(cmd,sizeof(cmd),alias_prog,args,1);
	aprog=popen(cmd,"r");
	
	UdmLog(Indexer,UDM_LOG_EXTRA,"Starting AliasProg: '%s'",cmd);
	
	if(aprog){
		ares=fgets(res,(int)rsize,aprog);
		res[rsize-1]='\0';
		pclose(aprog);
		if(!ares){
			UdmLog(Indexer,UDM_LOG_ERROR,"AliasProg didn't return result: '%s'",cmd);
			return(UDM_ERROR);
		}
	}else{
		UdmLog(Indexer,UDM_LOG_ERROR,"Can't start AliasProg: '%s'",cmd);
		return(UDM_ERROR);
	}
	if(ares[0]){
		ares+=strlen(ares);
		ares--;
		while((ares>=res)&&strchr(" \r\n\t",*ares)){
			*ares='\0';
			ares--;
		}
	}
	return UDM_OK;
}
